//UART manipulation and CS5490 read/write functions
//Designed by : ABHISHEK KUMAR (140250330004)

#define DELAY_READ_USEC 200000 //UART read delay (microseconds) 

static uint8_t *j,rbuff[5],zz[3];//for reading data through serial port

//############################################################################################ HELPING FUNCTIONS : UART & CS5490
int open_port(char *port)//to open the serial port
{
	int fd; //File descriptor for the port

	//The O_NOCTTY flag tells UNIX that this program doesn't want to be the "controlling terminal" for that port.
	//If you don't specify this then any input (such as keyboard abort signals and so forth) will affect your process.

	//The O_NDELAY flag tells UNIX that this program doesn't care what state the DCD signal line is in − whether
	//the other end of the port is up and running. If you do not specify this flag, your process will be put to sleep
	//until the DCD signal line is the space voltage.

	fd = open(port, O_RDWR | O_NOCTTY );//| O_NONBLOCK);//remove O_NONBLOCK to get blocking modes
	if(fd<0)
	{
		perror("XXXX : Unable to open SERIAL_DEVICE − ");
		return -1;	
	}
	
	printf("\n@==> Serial port %s opened successfully!!\n",port);
	//fcntl(fd, F_SETFL, 0);
	return fd;
}

int set_config_uart(int fd)
{
	int res;
	struct termios options;
	
	//The tcgetattr(3) function fills the termios structure you provide with the current serial port configuration.
	res = tcgetattr(fd, &options);//Get the current options for the port
	if(res<0)
	{
		perror("XXXX : Unable to get serial port attributes - ");			
		close(fd);
		return -1;
	}
	
	printf("@==> Serial port attributes read successfully!!\n");
	
	//printf("Current input baud rate = %d\n",cfgetispeed(&options));
	//printf("Current output baud rate = %d\n",cfgetospeed(&options));
	cfsetispeed(&options, B600);//Set the baud rates to 600
	cfsetospeed(&options, B600);//Set the baud rates to 600
	
	options.c_cflag &= ~PARENB;//No parity,thus cleared the bit
	options.c_cflag &= ~CSTOPB;

	//Unlike the baud rate, there is no convienience function to set the character size. Instead you must do a little bitmasking to set 		things up
	options.c_cflag &= ~CSIZE;//Mask the character size bits
	options.c_cflag |= CS8;//Select 8 data bits

	options.c_cflag &= ~CRTSCTS;//Disable hardware flow control
	options.c_iflag &= ~(IXON | IXOFF | IXANY);//disable software flow control

	//Raw input is unprocessed. Input characters are passed through exactly as they are received, when they are received.Generally you'll 		deselect the ICANON, ECHO, ECHOE, and ISIG options when using raw input
	options.c_lflag &= ~(ICANON | ECHO | ECHOE | ISIG);//Choosing raw input mode
	
	options.c_oflag &= ~OPOST;//Raw output is selected by resetting the OPOST option in the c_oflag member

	//The c_cflag member contains two options that should always be enabled, CLOCAL and CREAD. These will ensure that your program does 		not become the 'owner' of the port subject to sporatic job control and hangup signals, and also that the serial interface driver will 		read incoming data bytes.
	options.c_cflag |= (CLOCAL | CREAD);//Enable the receiver and set local mode

	//options.c_cc[VMIN] = 1;
        //options.c_cc[VTIME] = 0;
	
	tcflush(fd, TCIFLUSH);//clean the modem line,discards data written to the object referred to by fd but not transmitted,	or data 	received  but  not  read,depending on the value of queue_selector
	//TCIFLUSH-flushes data received but not read.
	//TCOFLUSH-flushes data written but not transmitted.
        //TCIOFLUSH-flushes both data received but not read, and data written but not transmitted.
	
	//After we set the baud rates and enable local mode and serial data receipt, we select the new configuration using tcsetattr(3).The 		TCSANOW constant specifies that all changes should occur immediately without waiting for output data to finish sending or input data 		to finish receiving.There are other constants to wait for input and output to finish or to flush the input and output buffers.
	//TCSANOW --> Make changes now without waiting for data to complete
	//TCSADRAIN --> Wait until everything has been transmitted
	//TCSAFLUSH --> Flush input and output buffers and make the change
	res = tcsetattr(fd, TCSANOW, &options);//Set the new options for the port
	if(res<0)
	{
		perror("XXXX : Unable to set serial port attributes - ");			
		close(fd);
		return -1;
	}
	//printf("Set input baud rate = %d\n",cfgetispeed(&options));
	//printf("Set output baud rate = %d\n",cfgetospeed(&options));
	printf("@==> Serial port attributes programmed successfully!!\n");
	//serial_all_flush(fd);//flush both serial port buffers
	return 0;//depict success
}

int sendsp(int fd,uint8_t d)//to send data(one byte only) through serial port
{
	int res;
	res = write(fd,&d,1);
	if(res!=1)
	{
		perror("XXXX : Unable to send data through serial port - ");	
		return -1;
	}
	return 0;//depict success
}

int readsp(int fd)//to read serial input buffer,only three values at a time
{
	int res;
	
	//The FNDELAY option causes the read function to return 0 if no characters are available on the port.
	//fcntl(fd, F_SETFL, FNDELAY);
	
	res = read(fd,rbuff,3);//read only 3 characters at a time
	if(res!=3)
	{
		perror("XXXX : Unable to read/read all(3 chars) data through serial port - ");			
		return -1;
	}
	
	return res;//returns 3 if all three characters are read successfully
}	

uint8_t readsp_single(int fd)//to read serial input buffer,only one values at a time
{
	int res;
	uint8_t d;
	
	//The FNDELAY option causes the read function to return 0 if no characters are available on the port.
	//fcntl(fd, F_SETFL, FNDELAY);
	
	res = read(fd,&d,1);//read only 3 characters at a time
	if(res<0)
	{
		perror("XXXX : Unable to read data through serial port - ");			
		return 0;
	}
	
	return d;
}

int bytes_available_input_buffer(int fd)//to retrieve number of bytes waiting in the input buffer
{
	int n,res;
	res = ioctl(fd,FIONREAD,&n);//"man tty_ioctl" - ioctls for terminals and serial lines
	if(res<0)
	{
		perror("XXXX : Unable to execute read number of bytes command - ");			
		return -1;
	}
	
	return n; 
}

int bytes_available_output_buffer(int fd)//to retrieve number of bytes waiting in the input buffer
{
	int n,res;
	res = ioctl(fd,TIOCOUTQ,&n);//"man tty_ioctl" - ioctls for terminals and serial lines	
	if(res<0)
	{
		perror("XXXX : Unable to execute read number of bytes command - ");			
		return -1;
	}
	
	return n; 
}

uint8_t bin_to_dec(uint8_t *d)
{
	uint8_t i,n=7;
	
	uint8_t sum = 0;
	
	for(i=0;i<=7;i++)
	{	
		sum = sum + ( ( d[i]=='1'?1:0 )* pow(2,n--) ); 
	}

	return sum;
}

uint8_t *dec_to_hex(uint8_t n)//very basic decimal(1 byte only) to hexadecimal converter 
{
	
	uint8_t x,*d = (uint8_t*)calloc(sizeof(uint8_t),3);
	d[2]=0;	
		
	x=n%16;	
	n=n/16;

	if(x<10)
		d[1]=x+48;
	else
		d[1]=65+(x-10);		
	
	n=n%16;

	if(n<10)
		d[0]=n+48;
	else
		d[0]=65+(n-10);		
	
	return d;
}

uint8_t *dec_to_bin(uint8_t n)//very basic decimal(1 byte only) to hexadecimal converter 
{
	
	uint8_t i=7,x,*d = (uint8_t*)calloc(sizeof(uint8_t),9);//to hold 8-bits in string form
	memset(d,'O',8);//because of string null problem,we fill the buffer with 'O' = alphabet O
	
	while(n!=0)
	{
		x=n%2;
		d[i--]=(x+48);
		n=n/2;
	}
			
	return d;
}

void serial_inp_flush(int fd)//clears input buffer
{
	int res;
	res = tcflush(fd, TCIFLUSH);//flushes data received but not read.
	if(res<0)
	{
		perror("XXXX : Unable to flush input serial buffer - ");			
		return;
	}
	//printf("@=> Input buffer cleared successfully!!\n");
}

void serial_out_flush(int fd)//clears output buffer
{
	int res;
	res = tcflush(fd, TCOFLUSH);//flushes data received but not read.
	if(res<0)
	{
		perror("XXXX : Unable to flush output serial buffer - ");			
		return;
	}
	//printf("@=> Output buffer cleared successfully!!\n");
}

void serial_all_flush(int fd)//clears input & output buffer
{
	int res;
	res = tcflush(fd, TCIOFLUSH);//flushes both data received but not read, and data written but not transmitted.
	if(res<0)
	{
		perror("XXXX : Unable to flush serial buffers - ");			
		return;
	}
	//printf("@=> All buffers cleared successfully!!\n");
}

uint8_t hex_to_dec(uint8_t *d)
{
	uint8_t u,t;

	if(d[1]>=48 && d[1]<=57)//if between 0-9
	{
		u = d[1]-48;
	}
	else//if between A-F
	{
		u = d[1]-65+10;
	}
	
	if(d[0]>=48 && d[0]<=57)//if between 0-9
	{
		t = d[0]-48;
	}
	else//if between A-F
	{
		t = d[0]-65+10;
	}

	return (t*16)+u;
}

long double dec_to_float_CS5490_1(uint8_t* c,uint8_t* b,uint8_t* a)
{
	//where c = MSB, b = MID ,a = LSB
	//CS5490_1 format for value in the range (-1.0 <= val < 1.0)

	long double sum;
	uint8_t i,n=1;
	
	if(c[0]=='O'||c[0]=='0')//check the 24th(last)(MSB) bit in the 24-bit number ,if = 1 number is -ve,else +ve
	{
		sum = 0.0;
	
		//process c
		for(i=1;i<=7;i++)
		{	
			sum = sum + ( ( c[i]=='1'?1:0 )* powl(2,-(n++)) ); 
		}
	
		//process b
		for(i=0;i<=7;i++)
		{	
			sum = sum + ( ( b[i]=='1'?1:0 )* powl(2,-(n++)) ); 
		}
	
	 	//process a
		for(i=0;i<=7;i++)
		{	
			sum = sum + ( ( a[i]=='1'?1:0 )* powl(2,-(n++)) ); 
		}
	}
	else//if number is -ve, XXXX UNTESTESTED BLOCK XXXX
	{	
		//make sure we copy them in other variables,bcoz values may change during conversions
		int v;		
		uint8_t cc[9],bb[9],aa[9],_c,_b,_a,*x;
		strcpy(cc,c);//MSB
		strcpy(bb,b);//MID
		strcpy(aa,a);//LSB

		cc[0]='O';//make msb of c[7:0] = 0
		v = ( bin_to_dec(cc)*256*256 + bin_to_dec(bb)*256 + bin_to_dec(aa) );//get the decimal of number[22:0]
		v = -v;//negate (2' complement)
		
		x=(uint8_t*)&v;
		_a=*(x+0);//LSB
		_b=*(x+1);//MID
		_c=*(x+2);//MSB
		_c = _c & ~(1<<7);//clear D7 bit of c byte

		return -dec_to_float_CS5490_1(dec_to_bin(_c),dec_to_bin(_b),dec_to_bin(_a));

	}

	return sum;
}

long double dec_to_float_CS5490_0(uint8_t* c,uint8_t* b,uint8_t* a)
{
	//where c = MSB, b = MID ,a = LSB
	//CS5490_0 format for value in the range (0 <= val < 1.0)

	long double sum=0.0;
	uint8_t i,n=1;
	
	//process c
	for(i=0;i<=7;i++)
	{	
		sum = sum + ( ( c[i]=='1'?1:0 )* powl(2,-(n++)) ); 
	}
	
	//process b
	for(i=0;i<=7;i++)
	{	
		sum = sum + ( ( b[i]=='1'?1:0 )* powl(2,-(n++)) ); 
	}
	
 	//process a
	for(i=0;i<=7;i++)
	{	
		sum = sum + ( ( a[i]=='1'?1:0 )* powl(2,-(n++)) ); 
	}
		
	return sum;
}

long double dec_to_float_CS5490_2(uint8_t* c,uint8_t* b,uint8_t* a)
{
	//where c = MSB, b = MID ,a = LSB
	//CS5490_0 format for value in the range (-2.0 <= val < 2.0)

	long double sum=0.0;
	uint8_t i,n=1;
	
	if( (c[0]=='0'||c[0]=='O') && c[1]=='1')
		sum = 1.0;
	else
		sum = 0.0;


	//process c
	for(i=2;i<=7;i++)
	{	
		sum = sum + ( ( c[i]=='1'?1:0 )* powl(2,-(n++)) ); 
	}
	
	//process b
	for(i=0;i<=7;i++)
	{	
		sum = sum + ( ( b[i]=='1'?1:0 )* powl(2,-(n++)) ); 
	}
	
 	//process a
	for(i=0;i<=7;i++)
	{	
		sum = sum + ( ( a[i]=='1'?1:0 )* powl(2,-(n++)) ); 
	}
		
	if(c[0]=='1' && (c[1]=='0'||c[1]=='O') )//-0 XXXX UNTESTES XXXX
	{
		sum = -sum;
	}
	else if(c[0]=='1' && c[1]=='1' )//-1 XXXX UNTESTES XXXX
	{
		sum = -(sum+1.0);
	}	

	return sum;
}

float read_temperature(int fd)//read CS5490 temperature
{
	float sum = 0.0;
	uint8_t c,i,n=1;
	int res;
	
	res = sendsp(fd,144);//send 16 page select command
	if(-1!=res)//if success
	{	
		res = sendsp(fd,27);//send 15 register read command
		if(-1!=res)//if success
		{	
			usleep(DELAY_READ_USEC);//let data to arrive from chip(utmost important here)
			res = readsp(fd);//read the serial port
			if(3==res)//if three characters are read successfully
			{	
				uint8_t *a=dec_to_bin(rbuff[0]);//LSB octet
				uint8_t *b=dec_to_bin(rbuff[1]);//Middle octet
				c=rbuff[2];//MSB octet
			
				//process b
				for(i=0;i<=7;i++)
				{	
					sum = sum + ( ( b[i]=='1'?1:0 )* powl(2,-(n++)) ); 
				}
	
			 	//process a
				for(i=0;i<=7;i++)
				{	
					sum = sum + ( ( a[i]=='1'?1:0 )* powl(2,-(n++)) ); 
				}
	
				free(b);
				free(a);

			}
			else
			{
				printf("XXXX : Error reading temperature!!\n");
				return 0.0;
			}
		}
	}
	
	return sum+c;
} 

int8_t write_full(int fd, uint8_t page ,uint8_t reg ,uint8_t c ,uint8_t b ,uint8_t a )//writes directly a 24-bit value to reg. on given page
{
	if(page<64 && reg<64)//only if reg and page is valid
	{		
		int8_t res;	
		uint8_t x=128;//D7,D6 = 1,0 for page select command
		x|=page;//select page
		serial_out_flush(fd);//flush output buffer,so that this data can be sent next immediately
		res = sendsp(fd,x);//send data
		if(-1!=res)//if success
		{
			x=0b01000000;//D7,D6 = 0,1 for write register command
			x|=reg;//select register
			res = sendsp(fd,x);//send write command first
			res = sendsp(fd,a);//send LSB octet
			res = sendsp(fd,b);//send MID octet
			res = sendsp(fd,c);//send MSB octet

			usleep(100000);//important
			//printf("Write command for register = %u,at page = %u sent successfully!!\n",reg,page);
			return 0;//depicts success
		}
		else
		{	printf("XXXX : Error writing register!!\n",reg,page);
			return -1;//depicts failure
		}
	}
	else
	{
		printf("XXXX : Invalid page/register!!\n");
		return -1;//depicts failure
	}
}

int8_t set_calibration_constants(int fd)//set calibration constants into CS5490 chips
{
	if(0==write_full(fd,16,00,hex_to_dec("10"),hex_to_dec("02"),hex_to_dec("0A")))//Config2
	if(0==write_full(fd,16,58,hex_to_dec("00"),hex_to_dec("01"),hex_to_dec("F4")))//No load threshold
	if(0==write_full(fd,16,51,hex_to_dec("00"),hex_to_dec("27"),hex_to_dec("10")))//Sample count,10000	
	if(0==write_full(fd,16,57,hex_to_dec("00"),hex_to_dec("03"),hex_to_dec("E8")))//Tsettle,
	if(0==write_full(fd,16,35,hex_to_dec("34"),hex_to_dec("2A"),hex_to_dec("C0")))//Vgain
	if(0==write_full(fd,16,37,hex_to_dec("51"),hex_to_dec("EC"),hex_to_dec("90")))//Iacoff
	if(0==sendsp(fd,213))//send continous conversion command(11010101)
			return 0;//depict success
	
	return -1;//depict failure
}

int8_t calc_meter(int fd,struct meter_param* mm)//this will calculate all three parameters and fill the structure members by the pointer
{
	//before executing this function,make sure your IC is ready to communicate and working
	int8_t res;
	uint8_t x,a,b,c,page,reg;
	 
	//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>> IRMS READ,Pg=16,Ad=6
	page = 16;
	reg = 6;
			
	x=128;//D7,D6 = 1,0 for page select command
	x|=page;//select page 
	serial_out_flush(fd);//flush output buffer,so that this data can be sent next immediately
	res = sendsp(fd,x);//send page select data
	if(res!=-1)//success sending command
	{
		serial_out_flush(fd);//flush output buffer,so that this data can be sent next immediately
		x=0;//D7,D6 = 0,0 for read register command
		x|=reg;//select register to read
		serial_all_flush(fd);//flush both buffers(utmost important here)
		res = sendsp(fd,x);//send read command
		if(-1!=res)//if success in sending read command
		{
			usleep(DELAY_READ_USEC);//wait for data to arrive
			if(3==readsp(fd))//if register read successfully
			{
				a=rbuff[0];//LSB octet
				b=rbuff[1];//Middle octet
				c=rbuff[2];//MSB octet
				mm->current = ( dec_to_float_CS5490_0(dec_to_bin(c),dec_to_bin(b),dec_to_bin(a) ) / 0.6 ) * 16;//current calc	
			}
			else
			{
				goto c_error;
			}
		}
		else
		{
			goto c_error;
		}
	}
	else 
	{
		goto c_error;
	}

	//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>> VRMS READ,Pg=16,Ad=7
	page = 16;
	reg = 7;
			
	x=128;//D7,D6 = 1,0 for page select command
	x|=page;//select page 
	serial_out_flush(fd);//flush output buffer,so that this data can be sent next immediately
	res = sendsp(fd,x);//send page select data
	if(res!=-1)//success sending command
	{
		serial_out_flush(fd);//flush output buffer,so that this data can be sent next immediately
		x=0;//D7,D6 = 0,0 for read register command
		x|=reg;//select register to read
		serial_all_flush(fd);//flush both buffers(utmost important here)
		res = sendsp(fd,x);//send read command
		if(-1!=res)//if success in sending read command
		{
			usleep(DELAY_READ_USEC);//wait for data to arrive
			if(3==readsp(fd))//if register read successfully
			{
				a=rbuff[0];//LSB octet
				b=rbuff[1];//Middle octet
				c=rbuff[2];//MSB octet
				mm->voltage = ( dec_to_float_CS5490_0(dec_to_bin(c),dec_to_bin(b),dec_to_bin(a) ) / 0.6 ) * 310;//voltage calc	
			}
			else
			{
				goto c_error;
			}
		}
		else
		{
			goto c_error;
		}
	}
	else 
	{
		goto c_error;
	}

	//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>> Active power(Pavg) READ,Pg=16,Ad=5
	page = 16;
	reg = 5;
			
	x=128;//D7,D6 = 1,0 for page select command
	x|=page;//select page 
	serial_out_flush(fd);//flush output buffer,so that this data can be sent next immediately
	res = sendsp(fd,x);//send page select data
	if(res!=-1)//success sending command
	{
		serial_out_flush(fd);//flush output buffer,so that this data can be sent next immediately
		x=0;//D7,D6 = 0,0 for read register command
		x|=reg;//select register to read
		serial_all_flush(fd);//flush both buffers(utmost important here)
		res = sendsp(fd,x);//send read command
		if(-1!=res)//if success in sending read command
		{
			usleep(DELAY_READ_USEC);//wait for data to arrive
			if(3==readsp(fd))//if register read successfully
			{
				a=rbuff[0];//LSB octet
				b=rbuff[1];//Middle octet
				c=rbuff[2];//MSB octet
				mm->act_power = ( dec_to_float_CS5490_1(dec_to_bin(c),dec_to_bin(b),dec_to_bin(a) ) / 0.36 ) * 4960;
			}
			else
			{
				goto c_error;
			}
		}
		else
		{
			goto c_error;
		}
	}
	else 
	{
		goto c_error;
	}

	//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>> Reactive power(Qavg) READ,Pg=16,Ad=14
	page = 16;
	reg = 14;
			
	x=128;//D7,D6 = 1,0 for page select command
	x|=page;//select page 
	serial_out_flush(fd);//flush output buffer,so that this data can be sent next immediately
	res = sendsp(fd,x);//send page select data
	if(res!=-1)//success sending command
	{
		serial_out_flush(fd);//flush output buffer,so that this data can be sent next immediately
		x=0;//D7,D6 = 0,0 for read register command
		x|=reg;//select register to read
		serial_all_flush(fd);//flush both buffers(utmost important here)
		res = sendsp(fd,x);//send read command
		if(-1!=res)//if success in sending read command
		{
			usleep(DELAY_READ_USEC);//wait for data to arrive
			if(3==readsp(fd))//if register read successfully
			{
				a=rbuff[0];//LSB octet
				b=rbuff[1];//Middle octet
				c=rbuff[2];//MSB octet
				mm->rea_power = ( dec_to_float_CS5490_1(dec_to_bin(c),dec_to_bin(b),dec_to_bin(a) ) / 0.36 ) * 4960;
			}
			else
			{
				goto c_error;
			}
		}
		else
		{
			goto c_error;
		}
	}
	else 
	{
		goto c_error;
	}

	//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>> Apparent power(S) READ,Pg=16,Ad=20
	page = 16;
	reg = 20;
			
	x=128;//D7,D6 = 1,0 for page select command
	x|=page;//select page 
	serial_out_flush(fd);//flush output buffer,so that this data can be sent next immediately
	res = sendsp(fd,x);//send page select data
	if(res!=-1)//success sending command
	{
		serial_out_flush(fd);//flush output buffer,so that this data can be sent next immediately
		x=0;//D7,D6 = 0,0 for read register command
		x|=reg;//select register to read
		serial_all_flush(fd);//flush both buffers(utmost important here)
		res = sendsp(fd,x);//send read command
		if(-1!=res)//if success in sending read command
		{
			usleep(DELAY_READ_USEC);//wait for data to arrive
			if(3==readsp(fd))//if register read successfully
			{
				a=rbuff[0];//LSB octet
				b=rbuff[1];//Middle octet
				c=rbuff[2];//MSB octet
				mm->app_power = ( dec_to_float_CS5490_1(dec_to_bin(c),dec_to_bin(b),dec_to_bin(a) ) / 0.36 ) * 4960;
			}
			else
			{
				goto c_error;
			}
		}
		else
		{
			goto c_error;
		}
	}
	else 
	{
		goto c_error;
	}
	
	//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>> Power factor READ,Pg=16,Ad=21
	page = 16;
	reg = 21;
			
	x=128;//D7,D6 = 1,0 for page select command
	x|=page;//select page 
	serial_out_flush(fd);//flush output buffer,so that this data can be sent next immediately
	res = sendsp(fd,x);//send page select data
	if(res!=-1)//success sending command
	{
		serial_out_flush(fd);//flush output buffer,so that this data can be sent next immediately
		x=0;//D7,D6 = 0,0 for read register command
		x|=reg;//select register to read
		serial_all_flush(fd);//flush both buffers(utmost important here)
		res = sendsp(fd,x);//send read command
		if(-1!=res)//if success in sending read command
		{
			usleep(DELAY_READ_USEC);//wait for data to arrive
			if(3==readsp(fd))//if register read successfully
			{
				a=rbuff[0];//LSB octet
				b=rbuff[1];//Middle octet
				c=rbuff[2];//MSB octet
				mm->pf = dec_to_float_CS5490_1(dec_to_bin(c),dec_to_bin(b),dec_to_bin(a));
			}
			else
			{
				goto c_error;
			}
		}
		else
		{
			goto c_error;
		}
	}
	else 
	{
		goto c_error;
	}

	//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>> Line frequency READ,Pg=16,Ad=49
	page = 16;
	reg = 49;
			
	x=128;//D7,D6 = 1,0 for page select command
	x|=page;//select page 
	serial_out_flush(fd);//flush output buffer,so that this data can be sent next immediately
	res = sendsp(fd,x);//send page select data
	if(res!=-1)//success sending command
	{
		serial_out_flush(fd);//flush output buffer,so that this data can be sent next immediately
		x=0;//D7,D6 = 0,0 for read register command
		x|=reg;//select register to read
		serial_all_flush(fd);//flush both buffers(utmost important here)
		res = sendsp(fd,x);//send read command
		if(-1!=res)//if success in sending read command
		{
			usleep(DELAY_READ_USEC);//wait for data to arrive
			if(3==readsp(fd))//if register read successfully
			{
				a=rbuff[0];//LSB octet
				b=rbuff[1];//Middle octet
				c=rbuff[2];//MSB octet
				mm->freq = (int)( dec_to_float_CS5490_1(dec_to_bin(c),dec_to_bin(b),dec_to_bin(a)) *4000);
				return 0;//successfully calculated all data upto here
			}
			else
			{
				goto c_error;
			}
		}
		else
		{
			goto c_error;
		}
	}
	else 
	{
		goto c_error;
	}

c_error:printf("XXXX : Error reading parameters!!\n");
	return -1;
		
}

